package com.esv.freight.app.module.complaint.vo;

import lombok.Data;

/**
 * @description: 投诉详情VO
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.complaint.vo.ComplaintDetailVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/05/28 13:30
 * @version:1.0
 */
@Data
public class ComplaintDetailVO {

    /**
     * 主键
     */
    private Long id;

    /**
     * 投诉编号
     */
    private String complaintNo;

    /**
     * 运单ID
     */
    private Long waybillId;

    /**
     * 运单号
     */
    private String waybillNo;

    /**
     * 投诉处理状态.1-待处理；2-已处理；3-已取消；
     */
    private Integer complaintState;

    /**
     * 投诉类型，1-运输失效；2-运输质量；3-服务态度；4-其他
     */
    private Integer complaintType;

    /**
     * 投诉对象，1-司机，2-平台，3-其他
     */
    private Integer complaintObject;

    /**
     * 投诉内容
     */
    private String complaintContent;

    /**
     * 上传照片01URL
     */
    private String pictureUrl01;

    /**
     * 上传照片02URL
     */
    private String pictureUrl02;
}
