package com.esv.freight.app.module.order.vo;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @description: 订单列表VO
 * @project: Freight
 * @name: com.esv.freight.app.module.order.vo.OrderListItemVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/18 11:00
 * @version:1.0
 */
@Data
public class OrderListItemVO {

    /**
     * 	订单ID
     */
    private Long id;

    /**
     * 	订单号
     */
    private String orderNO;

    /**
     * 订单状态.
     */
    private Integer orderState;

    /**
     * 审核状态
     */
    private Integer auditState;

    /**
     * 发货城市编码
     */
    private String deliveryCity;

    /**
     * 收货城市编码
     */
    private String receiveCity;

    /**
     * 货物名称编码
     */
    private Integer goodsName;

    /**
     * 货物订单量
     */
    private BigDecimal goodsTotalAmount;

    /**
     * 货物单位
     */
    private String goodsUnit;

    /**
     * 要求发货时间
     */
    private Date requiredDeliveryTime;

    /**
     * 要求交货时间
     */
    private Date requiredReceiveTime;

    /**
     * 订单创建时间
     */
    private Date createTime;

    /**
     * 订单来源
     */
    private String orderSource;
}
