package com.esv.freight.app.module.account.form;

import com.esv.freight.app.common.validator.groups.ValidatorDelete;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
/**
 * @description: 重置密码验证类
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.account.form.ModifyPasswordFrom
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/13 10:00
 * @version:1.0
 */
@Data
public class ModifyPasswordForm {

    /**
     * 原密码
     */
    @Length(min = 32, max = 32, message = "参数oldPwdd长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    @NotBlank(message = "参数pwd不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    private String oldPwd;

    /**
     * 新密码
     */
    @Length(min = 32, max = 32, message = "参数newPwd长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    @NotBlank(message = "参数pwd不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    private String newPwd;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
