package com.esv.freight.app.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @description:
 * @project: Freight
 * @name: com.esv.freight.app.feign.ReceiveAddressInterface
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/22 16:00
 * @version:1.0
 */
@FeignClient(value = "freight-customer-service")
public interface ReceiveAddressInterface {

    /**
     * 获取收货地址列表
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/customer/goodsowner/receive/address/all")
    JSONObject all(JSONObject bodyJson);

    /**
     * 删除收货地址
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/customer/goodsowner/receive/address/delete")
    JSONObject delete(JSONObject bodyJson);

    /**
     * 编辑收货地址
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/customer/goodsowner/receive/address/edit")
    JSONObject edit(JSONObject bodyJson);

    /**
     * 添加收货地址
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/customer/goodsowner/receive/address/add")
    JSONObject add(JSONObject bodyJson);

    /**
     * 收货地址详情
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/customer/goodsowner/receive/address/detail")
    JSONObject detail(JSONObject bodyJson);
}

