package com.esv.freight.app.module.waybill.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.app.common.response.ECode;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import com.esv.freight.app.feign.TmsInterface;
import com.esv.freight.app.module.account.service.AppLoginService;
import com.esv.freight.app.module.order.form.OrderQueryForm;
import com.esv.freight.app.module.waybill.form.WaybillQueryForm;
import com.esv.freight.app.module.waybill.vo.WaybillListItemVO;
import com.esv.freight.app.module.waybill.vo.WaybillListVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @description: 货主运单Controller
 * @project: Freight
 * @name: com.esv.freight.app.module.waybill.controller.OwnerWaybillController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/22 15:00
 * @version:1.0
 */
@RestController
@RequestMapping("/ownerBackend/waybill")
@Slf4j
@Validated
public class OwnerWaybillController {

    private AppLoginService appLoginService;
    private TmsInterface tmsInterface;

    private WaybillListVO mWaybillListVO;

    private void createTestData() {
        mWaybillListVO = new WaybillListVO();
        List<WaybillListItemVO> verifyList = new ArrayList<>();
        WaybillListItemVO itemVO = new WaybillListItemVO();
        itemVO.setId(10056L);
        itemVO.setWaybillNO("YD202004221300002");
        itemVO.setOrderNO("D2020042109300101");
        itemVO.setWaybillState(5);
        itemVO.setDeliveryCity("210100");
        itemVO.setReceiveCity("210100");
        itemVO.setGoodsName(1101);
        itemVO.setGoodsTotalAmount(new BigDecimal(26));
        itemVO.setGoodsUnit("吨");
        itemVO.setCreateTime(new Date());
        itemVO.setRequiredReceiveTime(new Date());
        itemVO.setRequiredDeliveryTime(new Date());
        itemVO.setVehicleNum("辽A12345");
        verifyList.add(itemVO);

        mWaybillListVO.setPageNum(1L);
        mWaybillListVO.setPageSize(20L);
        mWaybillListVO.setTotal(1L);
        mWaybillListVO.setRecordSize(1L);
        mWaybillListVO.setRecord(verifyList);
    }

    @Autowired
    public OwnerWaybillController(TmsInterface tmsInterface, AppLoginService appLoginService) {
        this.appLoginService = appLoginService;
        this.tmsInterface = tmsInterface;
        createTestData();
    }

    /**
     * description 获取运单列表
     * param [accessToken, waybillQueryForm]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/22 15:00
     **/
    @PostMapping("/list")
    public EResponse list(@RequestHeader("Union-Authorization") String accessToken, @RequestBody(required=false) @Validated(ValidatorList.class) WaybillQueryForm waybillQueryForm) {

        if(appLoginService.isInvalidAccessToken(accessToken)) {
            return EResponse.error(ECode.TOKEN_EXPIRED);
        }

        return EResponse.ok(mWaybillListVO);
    }
}
