package com.esv.freight.app.module.vehicle.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.List;
/**
 * @description: 车辆列表VO
 * @project: Freight
 * @name: com.esv.freight.app.module.vehicle.vo.VehicleListVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/28 16:00
 * @version:1.0
 */
@Data
public class VehicleListVO {

    /**
     * 每页记录条数
     **/
    private Long pageSize;

    /**
     * 当前页码
     **/
    private Long pageNum;

    /**
     * 总记录条数
     **/
    private Long total;

    /**
     * 当前页的记录条数
     **/
    private Long recordSize;

    /**
     * 数据
     **/
    private List<VehicleListItemVO> record;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
