package com.esv.freight.app.module.evaluate.form;

import com.esv.freight.app.common.validator.groups.ValidatorDetail;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.evaluate.form.DriverEvaluateForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/05/30 14:00
 * @version:1.0
 */
@Data
public class DriverEvaluateForm {

    /**
     * 主键
     */
    @NotNull(message = "参数id不能为空", groups = {ValidatorUpdate.class, ValidatorDetail.class})
    private Long id;

    /**
     * 司机ID
     */
    @NotNull(message = "参数driverId不能为空", groups = {ValidatorInsert.class})
    private Long driverId;

    /**
     * 司机姓名
     */
    @Length(max = 64, message = "参数driverName长度不合法", groups = {ValidatorList.class})
    private String driverName;

    /**
     * 运单ID
     */
    @NotNull(message = "参数货主ID不能为空", groups = {ValidatorInsert.class})
    private Long waybillId;

    /**
     * 装货便捷性评分
     */
    @Range(min = 1, max = 50, message = "无效的装货便捷性评分", groups = {ValidatorList.class})
    @NotNull(message = "参数loadingConvenience不能为空", groups = {ValidatorInsert.class})
    private Integer loadingConvenience;

    /**
     * 卸货便捷性评分
     */
    @Range(min = 1, max = 50, message = "无效的卸货便捷性评分", groups = {ValidatorList.class})
    @NotNull(message = "参数unloadingConvenience不能为空", groups = {ValidatorInsert.class})
    private Integer unloadingConvenience;

    /**
     * 评价描述
     */
    @Length(max = 1000, message = "参数评价描述长度不合法", groups = {ValidatorInsert.class})
    private String appraiseContent;

    /**
     * 当前页数
     */
    @Range(min = 1, max = 65535, message = "无效的pageNum", groups = {ValidatorList.class})
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Long pageNum;

    /**
     * 每页显示记录数
     */
    @Range(min = 1, max = 100, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Long pageSize;
}
