package com.esv.freight.app.module.message.vo;

import lombok.Data;

import java.util.Date;

/**
 * @description: 消息分类VO
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.message.vo.MessageTypeVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/06/10 16:50
 * @version:1.0
 */
@Data
public class MessageTypeVO {

    /**
     * 最后消息本文内容
     */
    private String messageContent;

    /**
     * 消息类型 101-货账单对账消息
     */
    private Integer messageType;

    /**
     * 消息标题
     */
    private String messageTitle;

    /**
     * 分类是否全部已读 0-未读；1-已读
     */
    private Boolean isRead;

    /**
     * 最后创建时间
     */
    private Date createTime;
}
