package com.esv.freight.app.module.order.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description: 获取订单分类统计信息VO
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.order.vo.OrderStatisticsVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/13 13:00
 * @version:1.0
 */
@Data
public class OrderStatisticsVO {

    /**
     * 	已发布订单数量
     */
    private Integer published;

    /**
     * 	执行中订单数量
     */
    private Integer executing;

    /**
     * 	待审核订单数量
     */
    private Integer pending;

    /**
     * 	已完结订单数量
     */
    private Integer complete;

    /**
     * 	已取消订单数量
     */
    private Integer cancelled;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
