package com.esv.freight.app.module.address.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.List;

/**
 * @description: 地址列表VO
 * @project: freight-app-service
 * @name: com.esv.freight.module.ownerBackend.account.address.vo.AddressBriefVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/17 10:00
 * @version:1.0
 */
@Data
public class AddressBriefVO {

    /**
     * 地址ID
     **/
    private Long id;
    /**
     * 地址名称
     */
    private String addressName;
    /**
     * 省份代码
     */
    private String provinceCode;
    /**
     * 市代码
     */
    private String cityCode;
    /**
     * 区县代码
     */
    private String districtCode;
    /**
     * 详细地址
     */
    private String detailAddress;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
