package com.esv.freight.app.module.map.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.feign.TrackInterface;
import com.esv.freight.app.module.map.form.DriverTrackForm;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;
import java.util.ArrayList;
import java.util.List;

/**
 * @description: 司机APP轨迹Controller
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.map.controller.DriverTrackController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/05/28 09:20
 * @version:1.0
 */
@RestController
@RequestMapping("/map/track/driver")
@Slf4j
@Validated
public class DriverTrackController {

    private TrackInterface trackInterface;

    @Autowired
    public DriverTrackController(TrackInterface trackInterface) {
        this.trackInterface = trackInterface;
    }

    @PostMapping("/upload")
    public EResponse upload(@RequestBody @Valid List<DriverTrackForm> driverTrackFormList) {
        // 调用获取货主发货地址列表接口
        JSONArray jsonArray = new JSONArray();
        for(DriverTrackForm driverTrackForm : driverTrackFormList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("time", driverTrackForm.getTime());
            jsonObject.put("driverId", driverTrackForm.getDriverId());
            jsonObject.put("lng", driverTrackForm.getLng());
            jsonObject.put("lat", driverTrackForm.getLat());
            jsonArray.add(jsonObject);
        }
        JSONObject result = trackInterface.add(jsonArray);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        return EResponse.ok();
    }
}
