package com.esv.freight.app.module.account.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.esv.freight.app.module.account.entity.AppLoginEntity;
import com.esv.freight.app.module.account.form.RefreshTokenForm;
import com.esv.freight.app.module.account.pojo.DriverAccountInfoPojo;
import com.esv.freight.app.module.account.pojo.OwnerAccountInfoPojo;
import com.esv.freight.app.module.account.pojo.TokenInfoPojo;
import com.esv.freight.app.module.account.vo.LoginVO;

/**
 * APP用户登录信息表
 *
 * @author 张志臣
 * @email zhangzhichen@esvtek.com
 * @date 2020-04-15 10:00
 */
public interface AppLoginService extends IService<AppLoginEntity> {

    /**
     * description 司机帐号登录
     * param [driverDetailInfoPojo]
     * return com.esv.freight.app.module.account.vo.LoginVO
     * author Administrator
     * createTime 2020/05/14 13:17
     **/
    LoginVO driverLogin(DriverAccountInfoPojo driverAccountInfoPojo);

    /**
     * description 货主帐号登录
     * param [ownerAccountInfoPojo]
     * return com.esv.freight.app.module.account.vo.LoginVO
     * author Administrator
     * createTime 2020/05/14 13:17
     **/
    LoginVO ownerLogin(OwnerAccountInfoPojo ownerAccountInfoPojo);

    /**
     * description 账号登出
     * param [accessToken]
     * return java.lang.Long
     * author 张志臣
     * createTime 2020/04/13 16:48
     **/
    void logout();

    /**
     * description 账号停用
     * param [phone]
     * return java.lang.Long
     * author 张志臣
     * createTime 2020/05/06 16:48
     **/
    void stopUsing(String phone, Integer type);

    /**
     * description 刷新token
     * param [accessToken, refreshTokenForm]
     * return java.lang.Long
     * author 张志臣
     * createTime 2020/04/13 16:48
     **/
    LoginVO refreshToken(RefreshTokenForm refreshTokenForm);

    /**
     * description 获取AppLoginEntity
     * param [phone]
     * return java.lang.Long
     * author 张志臣
     * createTime 2020/04/13 16:48
     **/
    AppLoginEntity getAccountByPhone(String phone);
}