package com.esv.freight.app.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @description:
 * @project: Freight
 * @name: com.esv.freight.app.feign.VehicleInterface
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/28 17:00
 * @version:1.0
 */
@FeignClient(value = "freight-customer-service")
public interface VehicleInterface {

    /**
     * 新增车辆
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "customer/carrier/vehicle/add")
    JSONObject add(JSONObject bodyJson);

    /**
     * 更新车辆
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "customer/carrier/vehicle/edit")
    JSONObject edit(JSONObject bodyJson);

    /**
     * 获取车辆详情
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "customer/carrier/vehicle/detail")
    JSONObject detail(JSONObject bodyJson);

    /**
     * 分页查询车辆列表
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "customer/carrier/vehicle/list")
    JSONObject list(JSONObject bodyJson);
}
