package com.esv.freight.app.module.waybill.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.esv.freight.app.common.response.ECode;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.util.ReqUtils;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import com.esv.freight.app.feign.TmsOrderInterface;
import com.esv.freight.app.feign.TmsWaybillInterface;
import com.esv.freight.app.module.account.service.AppLoginService;
import com.esv.freight.app.module.waybill.form.WaybillQueryForm;
import com.esv.freight.app.module.waybill.vo.WaybillListItemVO;
import com.esv.freight.app.module.waybill.vo.WaybillListVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @description: 货主运单Controller
 * @project: Freight
 * @name: com.esv.freight.app.module.waybill.controller.OwnerWaybillController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/22 15:00
 * @version:1.0
 */
@RestController
@RequestMapping("/ownerBackend/waybill")
@Slf4j
@Validated
public class OwnerWaybillController {

    private AppLoginService appLoginService;
    private TmsWaybillInterface tmsWaybillInterface;

    @Autowired
    public OwnerWaybillController(TmsWaybillInterface tmsWaybillInterface, AppLoginService appLoginService) {
        this.appLoginService = appLoginService;
        this.tmsWaybillInterface = tmsWaybillInterface;
    }

    /**
     * description 获取运单列表
     * param [accessToken, waybillQueryForm]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/22 15:00
     **/
    @PostMapping("/list")
    public EResponse list(@RequestBody(required=false) @Validated(ValidatorList.class) WaybillQueryForm waybillQueryForm) {

        String accessToken = ReqUtils.getTokenInfo().getAccessToken();
        if(appLoginService.isInvalidAccessToken(accessToken)) {
            return EResponse.error(ECode.TOKEN_EXPIRED);
        }

        // 调用运单列表分页查询接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("goodsOwnerId", waybillQueryForm.getUserId());
        reqJson.put("pageNum", waybillQueryForm.getPageNum());
        reqJson.put("pageSize", waybillQueryForm.getPageSize());
        reqJson.put("waybillStateList", waybillQueryForm.getWaybillStateList());
        if(!StringUtils.isEmpty(waybillQueryForm.getOrderNo())) {
            reqJson.put("orderNo", waybillQueryForm.getOrderNo());
        }
        log.info(reqJson.toJSONString());
        JSONObject result = tmsWaybillInterface.listWaybills(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        WaybillListVO pageResultVO = new WaybillListVO();
        JSONObject data = result.getJSONObject("data");
        pageResultVO.setPageSize(data.getLong("pageSize"));
        pageResultVO.setPageNum(data.getLong("pageNum"));
        pageResultVO.setTotal(data.getLong("total"));
        pageResultVO.setRecordSize(data.getLong("recordSize"));
        if(pageResultVO.getRecordSize() > 0) {
            JSONArray items = data.getJSONArray("records");
            List<WaybillListItemVO> records = new ArrayList<>();
            for(int i=0; i<items.size(); ++i) {
                WaybillListItemVO vo = new WaybillListItemVO();
                JSONObject object = items.getJSONObject(i);
                vo.setId(object.getLong("id"));
                vo.setWaybillNO(object.getString("waybillNO"));
                vo.setOrderNO(object.getString("orderNo"));
                vo.setWaybillState(object.getInteger("waybillState"));
                vo.setDeliveryCity(object.getString("deliveryCityCode"));
                vo.setReceiveCity(object.getString("receiveCityCode"));
                vo.setGoodsName(object.getInteger("goodsNameCode"));
                vo.setGoodsTotalAmount(object.getBigDecimal("goodsAmount"));
                vo.setGoodsUnit(object.getString("goodsUnit"));
                vo.setCreateTime(object.getDate("createTime"));
                vo.setVehicleId(object.getString("vehicleId"));
                vo.setVehicleNum(object.getString("vehicleLicenseNo"));
                records.add(vo);
            }

            pageResultVO.setRecord(records);
        }
        return EResponse.ok(pageResultVO);
    }
}
