package com.esv.freight.app.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.feign.NoticeInterface
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/17 17:48
 * @version:1.0
 */
@FeignClient(value = "freight-notice-service")
public interface NoticeInterface {

    /**
     * 校验短信验证码
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/notice/sms/captcha/check")
    JSONObject checkSmsCaptcha(JSONObject bodyJson);

    /**
     * 给指定帐号推送消息
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/notice/message/push2Device")
    JSONObject push2Device(JSONObject bodyJson);
}


