package com.esv.freight.app.module.account.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description: 司机账号详情VO
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.account.vo.DriverAccountDetailVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/13 17:00
 * @version:1.0
 */
@Data
public class DriverAccountDetailVO {

    // 账号ID
    private String id;

    // 承运商帐号ID
    private Long carrierId;

    // 承运商名称
    private String carrierName;

    // 登录帐号，司机手机号
    private String account;

    // 帐号状态：1-正常、2-停用
    private Integer accountStatus;

    // 创建来源：1-平台创建、2-自行注册
    private Integer sourceType;

    // 货主帐号审核状态：0-待审核、1-审核成功，2-审核失败
    private Integer auditStatus;

    // 姓名
    private String name;

    // 身份证号码
    private String idCard;

    // 身份证有效期 格式yyyy.MM.dd，或长期
    private String idCardExpireDate;

    // 身份证正面图片URL
    private String idCardFrontUrl;

    // 身份证反面图片URL
    private String idCardBackUrl;

    // 结算对象(字典表)：1-个人、2-所属承运商
    private Integer settlementType;

    // 性别(字典表)：1-男、2-女、3-未知
    private Integer sex;

    // 出生日期
    private String birthDate;

    // 民族
    private String nation;

    // 籍贯
    private String nativePlace;

    // 住址-省份代码
    private String provinceCode;

    // 住址-市代码
    private String cityCode;

    // 住址-区县代码
    private String districtCode;

    // 住址-详细地址
    private String detailAddress;

    // 驾驶证号码
    private String drivingLicense;

    // 驾驶证类型(字典表)：1-A1、2-A2、3-A3、4-A1A2、5-A2E、6-A2D、7-B1、8-B2、9-C1、0-其他
    private Integer drivingLicenseType;

    // 驾驶证有效期起
    private String drivingLicenseStartDate;

    // 驾驶证有效期止
    private String drivingLicenseEndDate;

    // 发证机关
    private String drivingLicenseIssueDepartment;

    // 初次获得驾驶证日期
    private String drivingLicenseInitDate;

    // 驾驶证正面图片URL
    private String drivingLicenseUrl;

    // 道路运输从业资格证-所驾驶车辆(字典表)：1-4.5吨及以下、2-4.5吨以上
    private Integer certificateVehicle;

    // 道路运输从业资格证-有效期止
    private String certificateEndDate;

    // 道路运输从业资格证-从业资格证号
    private String certificateNumber;

    // 道路运输从业资格证-正面图片URL
    private String certificateUrl;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
