package com.esv.freight.app.module.waybill.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.validator.groups.ValidatorDetail;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import com.esv.freight.app.feign.TmsOrderInterface;
import com.esv.freight.app.feign.TmsWaybillInterface;
import com.esv.freight.app.module.account.service.AppLoginService;
import com.esv.freight.app.module.waybill.form.UploadEvidenceForm;
import com.esv.freight.app.module.waybill.form.WaybillMultiQueryForm;
import com.esv.freight.app.module.waybill.form.WaybillQueryForm;
import com.esv.freight.app.module.waybill.vo.WaybillDetailVO;
import com.esv.freight.app.module.waybill.vo.WaybillListItemVO;
import com.esv.freight.app.module.waybill.vo.WaybillListVO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @description: 司机运单Controller
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.waybill.controller.DriverWaybillController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/22 15:00
 * @version:1.0
 */
@RestController
@RequestMapping("/driverBackend/waybill")
@Slf4j
@Validated
public class DriverWaybillController {

    private AppLoginService appLoginService;
    private TmsWaybillInterface tmsWaybillInterface;

    @Autowired
    public DriverWaybillController(TmsWaybillInterface tmsWaybillInterface, AppLoginService appLoginService) {
        this.appLoginService = appLoginService;
        this.tmsWaybillInterface = tmsWaybillInterface;
    }

    /**
     * description 获取运单列表
     * param waybillQueryForm
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/26 15:00
     **/
    @PostMapping("/list")
    public EResponse list(@RequestBody(required=false) @Validated(ValidatorList.class) WaybillQueryForm waybillQueryForm) {

        // 调用运单列表分页查询接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("driverId", waybillQueryForm.getUserId());
        reqJson.put("pageNum", waybillQueryForm.getPageNum());
        reqJson.put("pageSize", waybillQueryForm.getPageSize());
        reqJson.put("waybillStateList", waybillQueryForm.getWaybillStateList());
        log.info(reqJson.toJSONString());
        JSONObject result = tmsWaybillInterface.listWaybills(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        WaybillListVO pageResultVO = new WaybillListVO();
        JSONObject data = result.getJSONObject("data");
        pageResultVO.setPageSize(data.getLong("pageSize"));
        pageResultVO.setPageNum(data.getLong("pageNum"));
        pageResultVO.setTotal(data.getLong("totalSize"));
        pageResultVO.setRecordSize(data.getLong("recordSize"));
        if(pageResultVO.getRecordSize() > 0) {
            JSONArray items = data.getJSONArray("records");
            List<WaybillListItemVO> records = new ArrayList<>();
            for(int i=0; i<items.size(); ++i) {
                WaybillListItemVO vo = new WaybillListItemVO();
                JSONObject object = items.getJSONObject(i);
                vo.setId(object.getLong("id"));
                vo.setVehicleId(object.getLong("vehicleId"));
                vo.setVehicleLicenseNo(object.getString("vehicleLicenseNo"));
                vo.setWaybillNo(object.getString("waybillNo"));
                vo.setWaybillState(object.getInteger("waybillState"));
                vo.setDeliveryStrategy(object.getInteger("deliveryStrategy"));
                vo.setOrderId(object.getLong("orderId"));
                vo.setOrderNo(object.getString("orderNo"));
                vo.setGoodsOwnerId(object.getLong("goodsOwnerId"));
                vo.setGoodsOwnerName(object.getString("goodsOwnerName"));
                vo.setDeliveryCityCode(object.getString("deliveryCityCode"));
                vo.setReceiveCityCode(object.getString("receiveCityCode"));
                vo.setDriverId(object.getLong("driverId"));
                vo.setDriverName(object.getString("driverName"));
                vo.setDriverPhone(object.getString("driverPhone"));
                vo.setSettlementType(object.getString("settlementType"));
                vo.setCarrierId(object.getLong("carrierId"));
                vo.setCarrierName(object.getString("carrierName"));
                vo.setBusinessType(object.getInteger("businessType"));
                vo.setGoodsType(object.getInteger("goodsType"));
                vo.setGoodsNameCode(object.getInteger("goodsNameCode"));
                vo.setGoodsName(object.getString("goodsName"));
                vo.setGoodsAmount(object.getBigDecimal("goodsAmount"));
                vo.setFreightUnitPriceOutput(object.getBigDecimal("freightUnitPriceOutput"));
                vo.setDeliveryEvidenceId(object.getLong("deliveryEvidenceId"));
                vo.setDeliveryTime(object.getDate("deliveryTime"));
                vo.setDeliveryGoodsAmount(object.getBigDecimal("deliveryGoodsAmount"));
                vo.setReceiveEvidenceId(object.getLong("receiveEvidenceId"));
                vo.setReceiveTime(object.getDate("receiveTime"));
                vo.setReceiveGoodsAmount(object.getBigDecimal("receiveGoodsAmount"));
                vo.setPayVerifyState(object.getInteger("payVerifyState"));
                vo.setGoodsUnit(object.getInteger("goodsUnit"));
                vo.setFreightUnitPriceInput(object.getBigDecimal("freightUnitPriceInput"));
                vo.setCreateTime(object.getDate("createTime"));
                vo.setRequiredDeliveryTime(object.getDate("requiredDeliveryTime"));
                vo.setRequiredReceiveTime(object.getDate("requiredReceiveTime"));
                records.add(vo);
            }

            pageResultVO.setRecord(records);
        }
        return EResponse.ok(pageResultVO);
    }

    /**
     * description 获取运单详情
     * param waybillQueryForm
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/26 15:00
     **/
    @PostMapping("/detail")
    public EResponse detail(@RequestBody(required=false) @Validated(ValidatorDetail.class) WaybillQueryForm waybillQueryForm) {

        // 调用获取运单详情接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("id", waybillQueryForm.getWaybillId());
        log.info(reqJson.toJSONString());
        JSONObject result = tmsWaybillInterface.getWaybillDetail(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        WaybillDetailVO waybillDetailVO = new WaybillDetailVO();
        JSONObject data = result.getJSONObject("data");
        waybillDetailVO.setId(data.getLong("id"));
        waybillDetailVO.setGoodsDetail(data.getString("goodsDetail"));
        waybillDetailVO.setGoodsUnitPrice(data.getBigDecimal("goodsUnitPrice"));
        waybillDetailVO.setDeliveryAddressId(data.getLong("deliveryAddressId"));
        waybillDetailVO.setDeliveryAddressName(data.getString("deliveryAddressName"));
        waybillDetailVO.setDeliveryProvinceCode(data.getString("deliveryProvinceCode"));
        waybillDetailVO.setDeliveryCityCode(data.getString("deliveryCityCode"));
        waybillDetailVO.setDeliveryDistrictCode(data.getString("deliveryDistrictCode"));
        waybillDetailVO.setDeliveryDetailAddress(data.getString("deliveryDetailAddress"));
        waybillDetailVO.setDeliverer(data.getString("deliverer"));
        waybillDetailVO.setDelivererPhone(data.getString("delivererPhone"));
        waybillDetailVO.setReceiveAddressId(data.getLong("receiveAddressId"));
        waybillDetailVO.setReceiveAddressName(data.getString("receiveAddressName"));
        waybillDetailVO.setReceiveProvinceCode(data.getString("receiveProvinceCode"));
        waybillDetailVO.setReceiveCityCode(data.getString("receiveCityCode"));
        waybillDetailVO.setReceiveDistrictCode(data.getString("receiveDistrictCode"));
        waybillDetailVO.setReceiveDetailAddress(data.getString("receiveDetailAddress"));
        waybillDetailVO.setReceiver(data.getString("receiver"));
        waybillDetailVO.setReceiverPhone(data.getString("receiverPhone"));
        waybillDetailVO.setRequiredDeliveryTime(data.getDate("requiredDeliveryTime"));
        waybillDetailVO.setRequiredReceiveTime(data.getDate("requiredReceiveTime"));
        waybillDetailVO.setRequiredReceiptTime(data.getDate("requiredReceiptTime"));
        waybillDetailVO.setDeliveryGoodsAmount(data.getBigDecimal("deliveryGoodsAmount"));
        waybillDetailVO.setReceiveGoodsAmount(data.getBigDecimal("receiveGoodsAmount"));
        return EResponse.ok(waybillDetailVO);
    }

    /**
     * description 上传发货单据
     * param uploadEvidenceForm
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/05/08 15:00
     **/
    @PostMapping("/delivery/upload")
    public EResponse uploadDeliveryEvidence(@RequestBody(required=false) @Validated(ValidatorInsert.class) UploadEvidenceForm uploadEvidenceForm) {

        // 调用上传发货单据接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("waybillId", uploadEvidenceForm.getWaybillId());
        reqJson.put("goodsAmount", uploadEvidenceForm.getGoodsAmount());
        reqJson.put("deliveryTime", uploadEvidenceForm.getOccurrenceTime());
        if(StringUtils.isEmpty(uploadEvidenceForm.getPictureUrl01())) {
            reqJson.put("pictureUrl01", uploadEvidenceForm.getPictureUrl01());
        }
        if(StringUtils.isEmpty(uploadEvidenceForm.getPictureUrl02())) {
            reqJson.put("pictureUrl02", uploadEvidenceForm.getPictureUrl02());
        }
        if(StringUtils.isEmpty(uploadEvidenceForm.getPictureUrl03())) {
            reqJson.put("pictureUrl03", uploadEvidenceForm.getPictureUrl03());
        }
        if(StringUtils.isEmpty(uploadEvidenceForm.getPictureUrl04())) {
            reqJson.put("pictureUrl04", uploadEvidenceForm.getPictureUrl04());
        }
        log.info(reqJson.toJSONString());
        JSONObject result = tmsWaybillInterface.uploadDeliveryEvidence(reqJson);
        log.info(result.toJSONString());

        if (result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        return EResponse.ok();
    }

    /**
     * description 上传交货单据
     * param uploadEvidenceForm
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/05/08 15:00
     **/
    @PostMapping("/receive/upload")
    public EResponse uploadReceiveEvidence(@RequestBody(required=false) @Validated(ValidatorInsert.class) UploadEvidenceForm uploadEvidenceForm) {

        // 调用上传发货单据接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("waybillId", uploadEvidenceForm.getWaybillId());
        reqJson.put("goodsAmount", uploadEvidenceForm.getGoodsAmount());
        reqJson.put("receiveTime", uploadEvidenceForm.getOccurrenceTime());
        if(StringUtils.isEmpty(uploadEvidenceForm.getPictureUrl01())) {
            reqJson.put("pictureUrl01", uploadEvidenceForm.getPictureUrl01());
        }
        if(StringUtils.isEmpty(uploadEvidenceForm.getPictureUrl02())) {
            reqJson.put("pictureUrl02", uploadEvidenceForm.getPictureUrl02());
        }
        if(StringUtils.isEmpty(uploadEvidenceForm.getPictureUrl03())) {
            reqJson.put("pictureUrl03", uploadEvidenceForm.getPictureUrl03());
        }
        if(StringUtils.isEmpty(uploadEvidenceForm.getPictureUrl04())) {
            reqJson.put("pictureUrl04", uploadEvidenceForm.getPictureUrl04());
        }
        log.info(reqJson.toJSONString());
        JSONObject result = tmsWaybillInterface.uploadReceiveEvidence(reqJson);
        log.info(result.toJSONString());

        if (result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        return EResponse.ok();
    }

    /**
     * description 运单搜索
     * param waybillQueryForm
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/05/09 15:00
     **/
    @PostMapping("/list/multi/condition")
    public EResponse condition(@RequestBody(required=false) @Validated(ValidatorList.class) WaybillMultiQueryForm waybillMultiQueryForm) {

        // 调用运单列表分页查询接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("condition", waybillMultiQueryForm.getCondition());
        reqJson.put("pageNum", waybillMultiQueryForm.getPageNum());
        reqJson.put("pageSize", waybillMultiQueryForm.getPageSize());
        log.info(reqJson.toJSONString());
        JSONObject result = tmsWaybillInterface.condition(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") != 200) {
            return EResponse.error(result.getInteger("code"), result.getString("message"));
        }

        WaybillListVO pageResultVO = new WaybillListVO();
        JSONObject data = result.getJSONObject("data");
        pageResultVO.setPageSize(data.getLong("pageSize"));
        pageResultVO.setPageNum(data.getLong("pageNum"));
        pageResultVO.setTotal(data.getLong("totalSize"));
        pageResultVO.setRecordSize(data.getLong("recordSize"));
        if(pageResultVO.getRecordSize() > 0) {
            JSONArray items = data.getJSONArray("records");
            List<WaybillListItemVO> records = new ArrayList<>();
            for(int i=0; i<items.size(); ++i) {
                WaybillListItemVO vo = new WaybillListItemVO();
                JSONObject object = items.getJSONObject(i);
                vo.setId(object.getLong("id"));
                vo.setVehicleId(object.getLong("vehicleId"));
                vo.setVehicleLicenseNo(object.getString("vehicleLicenseNo"));
                vo.setWaybillNo(object.getString("waybillNo"));
                vo.setWaybillState(object.getInteger("waybillState"));
                vo.setDeliveryStrategy(object.getInteger("deliveryStrategy"));
                vo.setOrderId(object.getLong("orderId"));
                vo.setOrderNo(object.getString("orderNo"));
                vo.setGoodsOwnerId(object.getLong("goodsOwnerId"));
                vo.setGoodsOwnerName(object.getString("goodsOwnerName"));
                vo.setDeliveryCityCode(object.getString("deliveryCityCode"));
                vo.setReceiveCityCode(object.getString("receiveCityCode"));
                vo.setDriverId(object.getLong("driverId"));
                vo.setDriverName(object.getString("driverName"));
                vo.setDriverPhone(object.getString("driverPhone"));
                vo.setSettlementType(object.getString("settlementType"));
                vo.setCarrierId(object.getLong("carrierId"));
                vo.setCarrierName(object.getString("carrierName"));
                vo.setBusinessType(object.getInteger("businessType"));
                vo.setGoodsType(object.getInteger("goodsType"));
                vo.setGoodsNameCode(object.getInteger("goodsNameCode"));
                vo.setGoodsName(object.getString("goodsName"));
                vo.setGoodsAmount(object.getBigDecimal("goodsAmount"));
                vo.setFreightUnitPriceOutput(object.getBigDecimal("freightUnitPriceOutput"));
                vo.setDeliveryEvidenceId(object.getLong("deliveryEvidenceId"));
                vo.setDeliveryTime(object.getDate("deliveryTime"));
                vo.setDeliveryGoodsAmount(object.getBigDecimal("deliveryGoodsAmount"));
                vo.setReceiveEvidenceId(object.getLong("receiveEvidenceId"));
                vo.setReceiveTime(object.getDate("receiveTime"));
                vo.setReceiveGoodsAmount(object.getBigDecimal("receiveGoodsAmount"));
                vo.setPayVerifyState(object.getInteger("payVerifyState"));
                vo.setGoodsUnit(object.getInteger("goodsUnit"));
                vo.setFreightUnitPriceInput(object.getBigDecimal("freightUnitPriceInput"));
                vo.setCreateTime(object.getDate("createTime"));
                vo.setRequiredDeliveryTime(object.getDate("requiredDeliveryTime"));
                vo.setRequiredReceiveTime(object.getDate("requiredReceiveTime"));
                records.add(vo);
            }

            pageResultVO.setRecord(records);
        }
        return EResponse.ok(pageResultVO);
    }
}
