package com.esv.freight.app.module.grabbing.form;

import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.grabbing.form.OrderGrabbingForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/5/7 20:00
 * @version:1.0
 */
@Data
public class OrderGrabbingForm {

    /**
     * 主键
     */
    @NotNull(message = "参数抢单信息ID不能为空", groups = {ValidatorInsert.class})
    private Long orderGrabbingId;

    /**
     * 司机ID
     */
    @NotNull(message = "参数司机ID不能为空", groups = {ValidatorInsert.class})
    private Long driverId;

    /**
     * 车辆ID
     */
    @NotNull(message = "参数车辆ID不能为空", groups = {ValidatorInsert.class})
    private Long vehicleId;

    /**
     * 司机议价单价，9位整数，6位小数
     */
    @DecimalMax(value = "999999999.999999", message = "运费司机议价单价不合法", groups = {ValidatorInsert.class})
    @DecimalMin(value = "0.000000", message = "运费司机议价单价不合法", groups = {ValidatorInsert.class})
    private BigDecimal freightUnitPriceOutput;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
