package com.esv.freight.app.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.feign.DriverInterface
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/28 20:00
 * @version:1.0
 */
@FeignClient(value = "freight-customer-service")
public interface DriverInterface {

    /**
     * 查询司机详情-通过帐号
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/customer/carrier/driver/getDetailByAccount")
    JSONObject getDetailByAccount(JSONObject bodyJson);

    /**
     * 注册司机账号
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/customer/carrier/driver/register")
    JSONObject register(JSONObject bodyJson);

    /**
     * 帐号密码校验
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/customer/carrier/driver/account/check")
    JSONObject accountCheck(JSONObject bodyJson);

    /**
     * 更改司机账号信息
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/customer/carrier/driver/edit")
    JSONObject edit(JSONObject bodyJson);
}
