package com.esv.freight.app.module.account.pojo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.Date;

/**
 * @description:
 * @project: app-service
 * @name: com.esv.freight.app.module.account.pojo.TokenInfoPojo
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/14 11:21
 * @version:1.0
 */
@Data
public class TokenInfoPojo {

    /**
     * 用户ID
     */
    private Long accountId;
    /**
     * 手机号码(帐号)
     */
    private String account;
    /**
     * 帐号身份类型：1-司机、2-货主
     */
    private Integer accountType;
    /**
     * 帐号登录方式：1-帐号密码登录、2-短信验证码登录
     */
    private Integer loginMode;
    /**
     * 访问token
     */
    private String accessToken;
    /**
     * 刷新token
     */
    private String refreshToken;
    /**
     * 登录时的IP
     */
    private String ip;
    /**
     * 设备序列号
     */
    private String sn;
    /**
     * 终端类型：2-Android端、3-iOS端
     */
    private Integer deviceType;
    /**
     * 终端操作系统名称
     */
    private String osType;
    /**
     * 终端操作系统版本
     */
    private String osVersion;
    /**
     * 终端APP版本
     */
    private String appVersion;
    /**
     * 登录时间
     */
    private Long loginTime;
    /**
     * token刷新时间
     */
    private Long refreshTime;
    /**
     * 访问token有效期
     */
    private Long accessTokenValidTime;
    /**
     * 刷新token有效期
     */
    private Long refreshTokenValidTime;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
