package com.esv.freight.app.module.order.form;

import com.esv.freight.app.common.validator.groups.ValidatorDelete;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import javax.validation.constraints.NotBlank;

/**
 * @description: 订单列表验证类
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.order.form.OrderListForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/18 11:00
 * @version:1.0
 */
@Data
public class OrderListForm {

    /**
     * 订单类型：1-待审核、2-新增、3-执行中
     */
    @NotBlank(message = "参数type不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    private Integer type;

    /**
     * 当前页数
     */
    @NotBlank(message = "参数pageNum不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    private Integer pageNum;

    /**
     * 每页显示记录数
     */
    @NotBlank(message = "参数pageSize不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    private Integer pageSize;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
