package com.esv.freight.app.module.account.controller;

import com.alibaba.fastjson.JSONObject;
import com.esv.freight.app.feign.DictInterface;
import com.esv.freight.app.feign.NoticeInterface;
import com.esv.freight.app.module.account.form.*;
import com.esv.freight.app.module.account.service.AppLoginService;
import com.esv.freight.app.module.account.vo.AccountDetailVO;
import com.esv.freight.app.common.response.ECode;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.module.account.vo.LoginVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import java.util.UUID;

/**
 * @description: 账号Controller
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.account.controller.OwnerAccountController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/09 17:00
 * @version:1.0
 */
@RestController
@RequestMapping("/ownerBackend/account")
@Slf4j
@Validated
public class OwnerAccountController {

    private DictInterface dictInterface;
    private NoticeInterface noticeInterface;
    private AppLoginService appLoginService;

    @Autowired
    public OwnerAccountController(DictInterface dictInterface, NoticeInterface noticeInterface, AppLoginService appLoginService) {
        this.dictInterface = dictInterface;
        this.noticeInterface = noticeInterface;
        this.appLoginService = appLoginService;
    }

    /**
     * description 短信验证码登录
     * param [LoginBySmsForm]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/10 16:00
     **/
    @PostMapping("/login/loginBySms")
    public EResponse loginBySms(@RequestBody(required=false) @Validated(ValidatorInsert.class) LoginBySmsForm loginBySmsForm) {

        if(loginBySmsForm == null) {
            return EResponse.error(ECode.PARAM_ERROR);
        }

        // 调用通知服务验证短信接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("phone", loginBySmsForm.getPhone());
        reqJson.put("type", "login");
        reqJson.put("captcha", loginBySmsForm.getSmsCode());
        log.info(reqJson.toJSONString());
        JSONObject result = noticeInterface.checkSmsCaptcha(reqJson);
        log.info(result.toJSONString());
/*
        JSONObject reqJson1 = new JSONObject();
        reqJson1.put("type", "conse");
        log.info(reqJson1.toJSONString());
        JSONObject result1 = dictInterface.getDictByTypes(reqJson1);
        log.info(result1.toJSONString());
*/
        if(result.getInteger("code") == 200) {
            LoginVO loginByPwdVO = appLoginService.loginBySms(loginBySmsForm.getPhone());
            return EResponse.ok(loginByPwdVO);
        }

        return EResponse.error(result.getInteger("code"), result.getString("message"));
    }

    /**
     * description 帐号密码登录RequestHeader
     * param [LoginByPwdForm]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/10 16:00
     **/
    @PostMapping("/login/loginByPwd")
    public EResponse loginByPwd(@RequestBody(required=false) @Validated(ValidatorInsert.class) LoginByPwdForm loginByPwdForm) {

        if(loginByPwdForm == null) {
            return EResponse.error(ECode.PARAM_ERROR);
        }

        if(!appLoginService.isExistAccount(loginByPwdForm.getPhone())) {
            return EResponse.error(1001, "账号不存在");
        }

        // TODO，Feign调用货主账号密码,目前暂时先假定密码为1234qwer(MD5加密)
        if(!"62c8ad0a15d9d1ca38d5dee762a16e01".equals(loginByPwdForm.getPwd())) {
            return EResponse.error(1003, "密码错误");
        }

        LoginVO loginByPwdVO = appLoginService.loginByPwd(loginByPwdForm.getPhone());
        return EResponse.ok(loginByPwdVO);
    }

    /**
     * description 帐号登出
     * param
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/11 11:00
     **/
    @PostMapping("/logout")
    public EResponse logout(@RequestHeader("Union-Authorization") String accessToken) {
        appLoginService.logout(accessToken);
        return EResponse.ok();
    }

    /**
     * description 刷新Token
     * param [refreshToken] 刷新Token
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/13 09:00
     **/
    @PostMapping("/token/refresh")
    public EResponse refresh(@RequestHeader("Union-Authorization") String accessToken, @RequestBody(required=false) @Validated(ValidatorInsert.class) RefreshTokenForm refreshTokenForm) {

        LoginVO loginByPwdVO = appLoginService.refreshToken(accessToken, refreshTokenForm);
        return EResponse.ok(loginByPwdVO);
    }

    /**
     * description 获取帐号详情
     * param []
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/13 10:00
     **/
    @PostMapping("/detail")
    public EResponse detail(@RequestHeader("Union-Authorization") String accessToken) {

        if(appLoginService.isInvalidAccessToken(accessToken)) {
            return EResponse.error(ECode.TOKEN_EXPIRED);
        }

        AccountDetailVO accountDetailVO = appLoginService.getAccountDetailInfo(accessToken);
        return EResponse.ok(accountDetailVO);
    }

    /**
     * description 帐号实名认证
     * param [RealNameAuthForm]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/13 10:00
     **/
    @PostMapping("/realNameAuth")
    public EResponse realNameAuth(@RequestHeader("Union-Authorization") String accessToken, @RequestBody(required=false) @Validated(ValidatorInsert.class) RealNameAuthForm realNameAuthForm) {

        if(realNameAuthForm == null) {
            return EResponse.error(ECode.PARAM_ERROR);
        }

        if(appLoginService.isInvalidAccessToken(accessToken)) {
            return EResponse.error(ECode.TOKEN_EXPIRED);
        }

        // TODO，Feign调用货主账号密码,目前暂时设定成功
        if("1234qwer".equals(realNameAuthForm.getIdCard())) {
            return EResponse.error(1001, "身份证信息与照片不一致");
        }

        return EResponse.ok();
    }
}