package com.esv.freight.app.module.order.vo;

import lombok.Data;

/**
 * @description: 订单列表VO
 * @project: Freight
 * @name: com.esv.freight.app.module.order.vo.OrderListItemVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/18 11:00
 * @version:1.0
 */
@Data
public class OrderListItemVO {

    /**
     * 	订单ID
     */
    private Integer id;
    /**
     * 	订单号
     */
    private String orderNO;
    /**
     * 	发货地址省份
     */
    private String deliveryProviceCode;
    /**
     * 	发货地址城市
     */
    private String deliveryCityCode;
    /**
     * 	收货地址省份
     */
    private String receiveProviceCode;
    /**
     * 	收货地址城市
     */
    private String receiveCityCode;
    /**
     * 	货物类型，字典表
     */
    private Integer goodType;
    /**
     * 	货物订单量
     */
    private String goodsTotalAmount;
    /**
     * 	货物单位，字典表
     */
    private Integer goodsUnit;
    /**
     * 	发布时间
     */
    private Integer publishTime;
    /**
     * 	发货时间
     */
    private Integer deliveryTime;
    /**
     * 	订单来源，字典表
     */
    private String orderSource;
}
