package com.esv.freight.app.module.order.form;

import com.esv.freight.app.common.validator.groups.ValidatorDelete;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @description: 发布订单验证类
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.order.form.AddOrderForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/13 13:00
 * @version:1.0
 */
@Data
public class AddOrderForm {

    /**
     * 发货地址ID
     */
    @NotBlank(message = "参数deliveryAddressId不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    private Integer deliveryAddressId;

    /**
     * 收货地址ID
     */
    @NotBlank(message = "参数receiveAddressId不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    private Integer receiveAddressId;

    /**
     * 货物类型
     */
    @NotBlank(message = "参数goodsType不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    private Integer goodsType;

    /**
     * 货物名称编码
     */
    @NotBlank(message = "参数goodsNameCode不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    private Integer goodsNameCode;

    /**
     * 货物名称内容
     */
    @NotBlank(message = "参数goodsName不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    private String goodsName;

    /**
     * 货物明细
     */
    @NotBlank(message = "参数goodsDetail不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    @Length(max = 200, message = "货物明细长度不合法")
    private String goodsDetail;

    /**
     * 	货物单位
     */
    @NotBlank(message = "参数goodsUnit不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    private Integer goodsUnit;

    /**
     * 	货物单价
     */
    @NotBlank(message = "参数goodsUnitPrice不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    private Number goodsUnitPrice;

    /**
     *  要求发货时间
     */
    @NotBlank(message = "参数requiredDeliveryTime不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    private String requiredDeliveryTime;

    /**
     *  要求交货时间
     */
    @NotBlank(message = "参数requiredReceiveTime不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    private String requiredReceiveTime;

    /**
     *  车辆类型，主类型
     */
    private String vehicleTypeMain;

    /**
     *  车辆类型，子类型
     */
    private String vehicleTypeSub;

    /**
     *  车长
     */
    private String vehicleLength;

    /**
     *  备注
     */
    @Length(max = 200, message = "备注长度不合法")
    private String remark;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
