package com.esv.freight.app.module.order.controller;

import com.esv.freight.app.common.response.ECode;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.feign.DictInterface;
import com.esv.freight.app.feign.NoticeInterface;
import com.esv.freight.app.module.account.service.AppLoginService;
import com.esv.freight.app.module.order.form.OrderListForm;
import com.esv.freight.app.module.order.vo.OrderStatisticsVO;
import com.esv.freight.app.module.order.form.AddOrderForm;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @description: 订单Controller
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.order.controller.OrderController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/13 13:00
 * @version:1.0
 */
@RestController
@RequestMapping("/ownerBackend/order")
@Slf4j
@Validated
public class OrderController {

    private AppLoginService appLoginService;

    @Autowired
    public OrderController(AppLoginService appLoginService) {
        this.appLoginService = appLoginService;
    }

    /**
     * description 获取订单分类统计信息
     * param
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/11 11:00
     **/
    @PostMapping("/statistics/getCountByType")
    public EResponse getCountByType(@RequestHeader("Union-Authorization") String accessToken) {

        if(appLoginService.isInvalidAccessToken(accessToken)) {
            return EResponse.error(ECode.TOKEN_EXPIRED);
        }

        OrderStatisticsVO orderStatisticsVO = new OrderStatisticsVO();
        orderStatisticsVO.setCancelled(6);
        orderStatisticsVO.setComplete(5);
        orderStatisticsVO.setExecuting(3);
        orderStatisticsVO.setPending(6);
        orderStatisticsVO.setPublished(10);
        return EResponse.ok(orderStatisticsVO);
    }

    /**
     * description 获取订单列表
     * param [accessToken, addOrderForm]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/18 11:00
     **/
    @PostMapping("/list")
    public EResponse list(@RequestHeader("Union-Authorization") String accessToken, @RequestBody(required=false) @Validated(ValidatorInsert.class) OrderListForm orderListForm) {

        if(appLoginService.isInvalidAccessToken(accessToken)) {
            return EResponse.error(ECode.TOKEN_EXPIRED);
        }


        return EResponse.ok();
    }

    /**
     * description 发布订单
     * param [AddOrderForm]
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/04/13 14:00
     **/
    @PostMapping("/platform/add")
    public EResponse add(@RequestHeader("Union-Authorization") String accessToken, @RequestBody(required=false) @Validated(ValidatorInsert.class) AddOrderForm addOrderForm) {

        if(appLoginService.isInvalidAccessToken(accessToken)) {
            return EResponse.error(ECode.TOKEN_EXPIRED);
        }

        return EResponse.ok();
    }
}
