package com.esv.freight.app.module.account.vo;

import lombok.Data;

/**
 * @description: 账号详情VO
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.account.login.vo.AccountDetailVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/13 17:00
 * @version:1.0
 */
@Data
public class AccountDetailVO {

    // 账号ID
    private String id;

    // 认证状态：1-未认证、2-已认证
    private Integer authenticateStatus;

    // 货主类型：1-个人、2-企业
    private Integer ownerType;

    // 帐号
    private String account;

    // 姓名
    private String contactor;

    // 身份证号码
    private String idCard;

    // 身份证有效期 格式yyyy.MM.dd，或长期
    private String idCardExpireDate;

    // 身份证正面图片URL
    private String idCardFileFrontURL;

    // 身份证反面图片URL
    private String idCardFileBackURL;
}
