package com.esv.freight.app.module.account.form;

import com.esv.freight.app.common.validator.groups.ValidatorDelete;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
/**
 * @description: 短信验证码登录验证类
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.account.form.LoginBySmsForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/11 10:00
 * @version:1.0
 */
@Data
public class LoginBySmsForm {

    /**
     * 手机号
     */
    @Length(min = 11, max = 11, message = "参数phone长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    @NotBlank(message = "参数phone不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    private String phone;

    /**
     * 短信验证码
     */
    @Length(min = 6, max = 6, message = "参数pwd长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    @NotBlank(message = "参数smsCode不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class, ValidatorDelete.class})
    private String smsCode;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
