package com.esv.freight.app.module.order.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.util.List;

/**
 * @description: 订单列表VO
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.order.vo.OrderListVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/18 11:00
 * @version:1.0
 */
@Data
public class OrderListVO {

    /**
     * 	当前页数
     */
    private Integer pageNum;

    /**
     * 	每页显示记录数
     */
    private Integer pageSize;

    /**
     * 	总记录数
     */
    private Integer totalSize;

    /**
     * 	当前页的记录数
     */
    private Integer recordSize;

    /**
     * 记录列表
     **/
    private List<OrderListItemVO> records;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
