package com.esv.freight.app.module.address.form;

import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;

/**
 * @description:  新增收货地址验证类
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.address.form.CreateReceiveAddressForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/17 10:00
 * @version:1.0
 */
@Data
public class CreateReceiveAddressForm {

    /**
     * 	地址名称
     */
    @NotNull(message = "参数addressName不能为空")
    @Length(max = 50, message = "地址名称长度不合法")
    private String addressName;

    /**
     * 	省份代码
     */
    @Length(max = 6, message = "参数provinceCode长度不合法", groups = {ValidatorList.class})
    @Length(min = 6, max = 6, message = "参数provinceCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数provinceCode不能为空")
    private String provinceCode;

    /**
     * 	市代码
     */
    @Length(max = 6, message = "参数cityCode长度不合法", groups = {ValidatorList.class})
    @Length(min = 6, max = 6, message = "参数cityCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数cityCode不能为空")
    private String cityCode;

    /**
     *  区县代码
     */
    @Length(max = 6, message = "参数districtCode长度不合法", groups = {ValidatorList.class})
    @Length(min = 6, max = 6, message = "参数districtCode长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @NotNull(message = "参数districtCode不能为空")
    private String districtCode;

    /**
     * 	详细地址
     */
    @NotNull(message = "参数detailAddress不能为空")
    @Length(max = 50, message = "详细地址长度不合法")
    private String detailAddress;

    /**
     * 	收货人
     */
    @NotNull(message = "参数receiver不能为空")
    @Length(max = 20, message = "收货人长度不合法")
    private String receiver;

    /**
     *  收货人电话
     */
    @NotNull(message = "参数receiverPhone不能为空")
    @Length(max = 30, message = "收货人电话长度不合法")
    private String receiverPhone;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
