package com.esv.freight.app.module.address.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.app.common.exception.EException;
import com.esv.freight.app.module.account.dao.AppLoginDao;
import com.esv.freight.app.module.account.entity.AppLoginEntity;
import com.esv.freight.app.module.account.service.AppLoginService;
import com.esv.freight.app.module.address.service.AddressAccountService;
import com.esv.freight.app.module.address.vo.DeliveryAddressListVO;
import org.springframework.stereotype.Service;

@Service("addressAccountService")
public class AddressAccountServiceImpl extends ServiceImpl<AppLoginDao, AppLoginEntity> implements AddressAccountService {

    @Override
    public String getPhoneByAccessToken(String accessToken) {
        AppLoginEntity entity = this.getAccountByAccessToken(accessToken);
        if(entity == null) {
            throw new EException(1, "未找到accessToken");
        }

        return entity.getPhone();
    }

    private AppLoginEntity getAccountByAccessToken(String accessToken) {
        QueryWrapper<AppLoginEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("access_token", accessToken);
        return this.baseMapper.selectOne(queryWrapper);
    }
}
