package com.esv.freight.app.module.contract.vo;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.contract.vo.OwnerContractDetailVO
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/06/05 13:25
 * @version:1.0
 */
@Data
public class OwnerContractDetailVO {

    /**
     *
     */
    private Long id;
    /**
     * 合同类型：1-货主与平台合同、2-司机与平台合同
     */
    private Integer contractType;
    /**
     * 合同文件ID
     */
    private String contractFileId;
    /**
     * 合同文件URL
     */
    private String contractFileUrl;
    /**
     * 合同编号
     */
    private String contractNumber;
    /**
     * 业务编号（订单号或运单号）
     */
    private String businessNumber;
    /**
     * 客户ID
     */
    private Long customerId;
    /**
     * 客户名称
     */
    private String customerName;
    /**
     * 客户（货主或司机）签订时间
     */
    private Long customerSignTime;
    /**
     * 平台签订时间
     */
    private Long platformSignTime;
    /**
     * 合同签订完成：1-是，2-否
     */
    private Integer signComplete;
    /**
     * 合同生效时间
     */
    private Long effectiveTime;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
