package com.esv.freight.app.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.feign.OwnerComplaintInterface
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/05/28 14:20
 * @version:1.0
 */
@FeignClient(value = "freight-tms-service")
public interface OwnerComplaintInterface {

    /**
     * 分页查询
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/complaint/owner/list")
    JSONObject list(JSONObject bodyJson);

    /**
     * 详情查询
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/complaint/owner/detail")
    JSONObject detail(JSONObject bodyJson);

    /**
     * 新增投诉
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/complaint/owner/add")
    JSONObject add(JSONObject bodyJson);

    /**
     * 编辑投诉
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/complaint/owner/edit")
    JSONObject edit(JSONObject bodyJson);

    /**
     * 取消投诉
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/complaint/owner/cancel")
    JSONObject cancel(JSONObject bodyJson);
}
