package com.esv.freight.app.module.message.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.app.common.component.TokenComponent;
import com.esv.freight.app.common.exception.EException;
import com.esv.freight.app.common.util.ReqUtils;
import com.esv.freight.app.module.account.pojo.TokenInfoPojo;
import com.esv.freight.app.module.message.dao.AccountDeviceInfoDao;
import com.esv.freight.app.module.message.entity.AccountDeviceInfoEntity;
import com.esv.freight.app.module.message.form.AccountDeviceForm;
import com.esv.freight.app.module.message.service.AccountDeviceInfoService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service("AccountDeviceInfoService")
public class AccountDeviceInfoServiceImpl extends ServiceImpl<AccountDeviceInfoDao, AccountDeviceInfoEntity> implements AccountDeviceInfoService {

    private TokenComponent tokenComponent;

    @Autowired
    public AccountDeviceInfoServiceImpl(TokenComponent tokenComponent) {
        this.tokenComponent = tokenComponent;
    }

    @Override
    public void saveAccountDevice(AccountDeviceForm accountDeviceForm) {

        QueryWrapper<AccountDeviceInfoEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .eq(AccountDeviceInfoEntity::getAccountId, accountDeviceForm.getAccountId());
        this.remove(queryWrapper);

        AccountDeviceInfoEntity accountDeviceInfoEntity = new AccountDeviceInfoEntity();
        BeanUtils.copyProperties(accountDeviceForm, accountDeviceInfoEntity);
        accountDeviceInfoEntity.setUpdateTime(new Date());
        accountDeviceInfoEntity.setAccountType(Integer.parseInt(ReqUtils.getRequestHeader("accountType")));
        accountDeviceInfoEntity.setDeviceType(Integer.parseInt(ReqUtils.getRequestHeader("Source-Type")));
        accountDeviceInfoEntity.setTenantId(Long.parseLong(ReqUtils.getRequestHeader("tenantId")));
        save(accountDeviceInfoEntity);
    }

    @Override
    public String getDeviceSn(Long accountId, Integer deviceType) {
        AccountDeviceInfoEntity entity = lambdaQuery().eq(AccountDeviceInfoEntity::getAccountId, accountId)
                .eq(AccountDeviceInfoEntity::getDeviceType, deviceType).one();

        if(entity == null) {
            throw new EException(1001, "无效的账号ID");
        }
        return entity.getDeviceSn();
    }

    @Override
    public void accountLogout() {
        TokenInfoPojo tokenInfoPojo = this.tokenComponent.getTokenInfo();

        QueryWrapper<AccountDeviceInfoEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.lambda()
                .eq(AccountDeviceInfoEntity::getAccountId, tokenInfoPojo.getAccountId());
        this.remove(queryWrapper);
    }
}
