package com.esv.freight.app.module;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.junit.After;
import org.junit.Before;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

/**
 * @description:
 * @project: app-service
 * @name: com.esv.freight.app.module.BaseTestController
 * @author: 黄朝斌
 * @email: huangchaobin@esvtek.com
 * @createTime: 2020/05/14 10:21
 * @version:1.0
 */
@Slf4j
@Data
public class BaseTestController {

    @Autowired
    WebApplicationContext webApplicationContext;

    MockMvc mockMvc;

    @Before
    public void before() {
        log.info("=================================== Test Start ===================================");
        mockMvc = MockMvcBuilders.webAppContextSetup(webApplicationContext).build();
    }

    @After
    public void after() {
        log.info("=================================== Test End ===================================");
    }

    public HttpHeaders getDefaultHttpHeaders() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("gateway_traceid", String.valueOf(System.currentTimeMillis()));
        httpHeaders.add("esv_system", "app");
        httpHeaders.add("esv_data_perm", "1");
        httpHeaders.add("esv_tenant", "1");
        httpHeaders.add("esv_department", "1");
        httpHeaders.add("esv_department_children", "1,2,3");
        httpHeaders.add("esv_user", "1");
        httpHeaders.add("esv_account", "admin");
        httpHeaders.add("Source-Type", "2");
        httpHeaders.add("osType", "Android_test");
        httpHeaders.add("osVer", "10.0.0_test");
        httpHeaders.add("mobileId", "1234ASDFOWEF_test");
        httpHeaders.add("cVer", "1.0.0");
        httpHeaders.add("accountType", "1");
        return httpHeaders;
    }

}
