package com.esv.freight.app.module.account.form;

import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import com.esv.freight.app.module.account.validator.groups.*;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.module.ownerBackend.account.form.LoginForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/10 16:00
 * @version:1.0
 */
@Data
public class LoginForm {

    /**
     * 手机号
     */
    @Length(min = 11, max = 11, message = "参数phone长度不合法", groups = {ValidatorResetPwd.class, ValidatorLoginByPwd.class, ValidatorLoginBySms.class, ValidatorAccountExist.class, ValidatorDriverLoginBySms.class})
    @NotBlank(message = "参数phone不能为空", groups = {ValidatorResetPwd.class, ValidatorLoginByPwd.class, ValidatorLoginBySms.class, ValidatorAccountExist.class, ValidatorDriverLoginBySms.class})
    private String phone;

    /**
     * 短信验证码
     */
    @Length(min = 6, max = 6, message = "参数smsCode长度不合法", groups = {ValidatorResetPwd.class, ValidatorLoginBySms.class, ValidatorDriverLoginBySms.class})
    @NotBlank(message = "参数smsCode不能为空", groups = {ValidatorResetPwd.class, ValidatorLoginBySms.class})
    private String smsCode;

    /**
     * 密码
     */
    @Length(min = 32, max = 32, message = "参数pwd长度不合法", groups = {ValidatorResetPwd.class, ValidatorLoginByPwd.class})
    @NotBlank(message = "参数pwd不能为空", groups = {ValidatorResetPwd.class, ValidatorLoginByPwd.class})
    private String pwd;

    /**
     * 承运商帐号ID
     */
    @NotNull(message = "参数carrierId不能为空", groups = {ValidatorDriverLoginBySms.class})
    private Long carrierId;

    /**
     * 推送设备ID
     */
    @NotBlank(message = "参数pushId不能为空", groups = {ValidatorResetPwd.class, ValidatorLoginByPwd.class, ValidatorLoginBySms.class, ValidatorDriverLoginBySms.class})
    private String pushId;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
