package com.esv.freight.app.module.message.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.esv.freight.app.common.constants.AccountConstants;
import com.esv.freight.app.common.exception.EException;
import com.esv.freight.app.common.util.ReqUtils;
import com.esv.freight.app.feign.NoticeInterface;
import com.esv.freight.app.module.account.entity.AppLoginEntity;
import com.esv.freight.app.module.account.service.AppLoginService;
import com.esv.freight.app.module.message.dao.BusinessMessageDao;
import com.esv.freight.app.module.message.entity.BusinessMessageEntity;
import com.esv.freight.app.module.message.form.PushMessageForm;
import com.esv.freight.app.module.message.service.AccountDeviceInfoService;
import com.esv.freight.app.module.message.service.BusinessMessageService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Slf4j
@Service("BusinessMessageService")
public class BusinessMessageServiceImpl extends ServiceImpl<BusinessMessageDao, BusinessMessageEntity> implements BusinessMessageService {

    private NoticeInterface noticeInterface;
    private AccountDeviceInfoService accountDeviceInfoService;
    private AppLoginService appLoginService;

    @Autowired
    public BusinessMessageServiceImpl(AppLoginService appLoginService, NoticeInterface noticeInterface, AccountDeviceInfoService accountDeviceInfoService) {
        this.noticeInterface = noticeInterface;
        this.accountDeviceInfoService = accountDeviceInfoService;
        this.appLoginService = appLoginService;
    }

    @Override
    public void insertMessage(PushMessageForm pushMessageForm) {

        // 1:保存消息
        BusinessMessageEntity entity = new BusinessMessageEntity();
        BeanUtils.copyProperties(pushMessageForm, entity);
        entity.setAccountType(pushMessageForm.getAppType());

        JSONObject jo;
        if(pushMessageForm.getMessageType() == AccountConstants.MESSAGE_TYPE_BILL_CONFIRM) {
            jo = get101Message(pushMessageForm);
        }
        else {
            throw new EException(1001, "无效的消息类型");
        }

        entity.setMessageContent(jo.getString("msg_content"));
        entity.setMessageTitle(jo.getString("title"));
        entity.setMessageData(pushMessageForm.getMessageData());
        save(entity);

        // 2:调用给指定设备推送消息接口
        AppLoginEntity appLoginEntity = appLoginService.getAccountById(pushMessageForm.getAccountId());
        if(appLoginEntity == null) {
            return;
        }

        JSONObject reqJson = new JSONObject();
        if(pushMessageForm.getAppType() == AccountConstants.ACCOUNT_TYPE_DRIVER) {
            reqJson.put("appType", 2); // 给指定设备推送消息接口APP类型：1-货主、2-司机
        }
        else {
            reqJson.put("appType", 1);
        }

        if(appLoginEntity.getDeviceType() == AccountConstants.APP_TYPE_ANDROID) {
            reqJson.put("deviceType", 1); // 设备类型：1-android、2-ios
        }
        else {
            reqJson.put("deviceType", 2);
        }

        reqJson.put("registrationId", accountDeviceInfoService.getDeviceSn(pushMessageForm.getAccountId(), appLoginEntity.getDeviceType()));
        reqJson.put("message", jo);

        JSONObject result;
        log.info(reqJson.toJSONString());
        result = noticeInterface.push2Device(reqJson);
        log.info(result.toJSONString());

        if(result.getInteger("code") == 200) {
            String msgId = result.getJSONObject("data").getString("msgId");
            lambdaUpdate()
                    .eq(BusinessMessageEntity::getId, entity.getId())
                    .set(BusinessMessageEntity::getMsgId, msgId)
                    .update();
        }
    }

    private JSONObject get101Message(PushMessageForm pushMessageForm) {
        JSONObject jo = JSONObject.parseObject(pushMessageForm.getMessageData());
        String billNo = jo.getString("billNo");
        JSONObject reqMessage = new JSONObject();
        reqMessage.put("title", "账单提醒");
        String content = "您的新账单"+billNo+"已经生成，请尽快确认";
        reqMessage.put("msg_content", content);
        JSONObject extras = new JSONObject();
        extras.put("messageType", AccountConstants.MESSAGE_TYPE_BILL_CONFIRM);
        extras.put("data", jo);
        reqMessage.put("extras", extras);
        return reqMessage;
    }
}
