package com.esv.freight.app.module.evaluate.form;

import com.esv.freight.app.common.validator.groups.ValidatorDetail;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.evaluate.form.OwnerEvaluateForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/05/30 14:00
 * @version:1.0
 */
@Data
public class OwnerEvaluateForm {

    /**
     * 主键
     */
    @NotNull(message = "参数id不能为空", groups = {ValidatorUpdate.class, ValidatorDetail.class})
    private Long id;

    /**
     * 货主ID
     */
    @NotNull(message = "参数goodsOwnerId不能为空", groups = {ValidatorInsert.class})
    private Long goodsOwnerId;

    /**
     * 货主姓名
     */
    @Length(max = 64, message = "参数货主姓名长度不合法", groups = {ValidatorList.class})
    private String goodsOwnerName;

    /**
     * 运单ID
     */
    @NotNull(message = "参数货主ID不能为空", groups = {ValidatorInsert.class})
    private Long waybillId;

    /**
     * 准时装货评分
     */
    @Range(min = 1, max = 50, message = "无效的准时到达装货评分", groups = {ValidatorInsert.class})
    @NotNull(message = "参数onTimeLoading不能为空", groups = {ValidatorInsert.class})
    private Integer onTimeLoading;

    /**
     * 准时卸货评分
     */
    @Range(min = 1, max = 50, message = "无效的准时到达卸货评分", groups = {ValidatorInsert.class})
    @NotNull(message = "参数onTimeUnloading不能为空", groups = {ValidatorInsert.class})
    private Integer onTimeUnloading;

    /**
     * 货物安全到达评分
     */
    @Range(min = 1, max = 50, message = "无效的货物安全到达评分", groups = {ValidatorInsert.class})
    @NotNull(message = "参数safeArrival不能为空", groups = {ValidatorInsert.class})
    private Integer safeArrival;

    /**
     * 服务态度评分
     */
    @Range(min = 1, max = 50, message = "无效的服务态度评分", groups = {ValidatorInsert.class})
    @NotNull(message = "参数serviceAttitude不能为空", groups = {ValidatorInsert.class})
    private Integer serviceAttitude;

    /**
     * 评价描述
     */
    @Length(max = 1000, message = "参数评价描述长度不合法", groups = {ValidatorInsert.class})
    private String appraiseContent;

    /**
     * 当前页数
     */
    @Range(min = 1, max = 65535, message = "无效的pageNum", groups = {ValidatorList.class})
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Long pageNum;

    /**
     * 每页显示记录数
     */
    @Range(min = 1, max = 100, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Long pageSize;
}
