package com.esv.freight.app.module.account.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @description: APP用户登录信息表
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.account.entity.AppLoginEntity
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/13 14:00
 * @version:1.0
 */
@Data
@TableName("app_login_info")
public class AppLoginEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    @TableId
    private Long id;
    /**
     * 手机号码
     */
    private String phone;
    /**
     * 帐号身份类型：1-司机、2-货主
     */
    private Integer accountType;
    /**
     * 帐号登录方式：1-帐号密码登录、2-短信验证码登录
     */
    private Integer loginMode;
    /**
     * 终端类型：2-Android端、3-iOS端
     */
    private Integer deviceType;
    /**
     * 终端操作系统名称
     */
    private String osType;
    /**
     * 终端操作系统版本
     */
    private String osVersion;
    /**
     * 终端APP版本
     */
    private String appVersion;
    /**
     * 终端登录时的IP
     */
    private String ip;
    /**
     * 设备序列号
     */
    private String sn;
    /**
     * 登录状态：1-登录中、2-已登出
     */
    private Integer loginStatus;
    /**
     * 登录时间
     */
    private Date loginTime;
    /**
     * 登出时间
     */
    @TableField(insertStrategy = FieldStrategy.IGNORED, updateStrategy = FieldStrategy.IGNORED)
    private Date logoutTime;
    /**
     * 访问token
     */
    private String accessToken;
    /**
     * 刷新token
     */
    private String refreshToken;
    /**
     * token刷新时间
     */
    @TableField(insertStrategy = FieldStrategy.IGNORED, updateStrategy = FieldStrategy.IGNORED)
    private Date refreshTime;
    /**
     * 访问token有效期
     */
    private Date accessTokenValidTime;
    /**
     * 刷新token有效期
     */
    private Date refreshTokenValidTime;
}
