package com.esv.freight.app.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.feign.DriverComplaintInterface
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/05/29 17:30
 * @version:1.0
 */
@FeignClient(value = "freight-tms-service")
public interface DriverComplaintInterface {

    /**
     * 分页查询
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/complaint/driver/list")
    JSONObject list(JSONObject bodyJson);

    /**
     * 详情查询
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/complaint/driver/detail")
    JSONObject detail(JSONObject bodyJson);

    /**
     * 新增投诉
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/complaint/driver/add")
    JSONObject add(JSONObject bodyJson);

    /**
     * 编辑投诉
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/complaint/driver/edit")
    JSONObject edit(JSONObject bodyJson);

    /**
     * 取消投诉
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/complaint/driver/cancel")
    JSONObject cancel(JSONObject bodyJson);
}
