package com.esv.freight.app.module.bill.pojo;

import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.bill.pojo.DriverBillDetailPojo
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/06/03 14:10
 * @version:1.0
 */
@Data
public class DriverBillDetailPojo {

    /**
     * 主键
     */
    @TableId
    private Long id;

    /**
     * 对账单号，YFZD+”8位日期“+”6位序号“
     */
    private String payBillNo;

    /**
     * 账单开始时间
     */
    private Date billTimeBucketStart;

    /**
     * 账单结束时间
     */
    private Date billTimeBucketEnd;

    /**
     * 结算对象 个人、某个承运商
     */
    private Integer settlementClient;

    /**
     * 结算方式
     */
    private Integer settleMode;

    /**
     * 所属承运商ID
     */
    private Long carrierId;

    /**
     * 所属承运商名称
     */
    private String carrierName;

    /**
     * 司机ID
     */
    private Long driverId;

    /**
     * 司机名称
     */
    private String driverName;

    /**
     * 运费
     */
    private BigDecimal freightPrice = BigDecimal.ZERO;

    /**
     * 预付款
     */
    private BigDecimal prepay = BigDecimal.ZERO;

    /**
     * 油卡费
     */
    private BigDecimal gasoline = BigDecimal.ZERO;

    /**
     * 亏吨
     */
    private BigDecimal less = BigDecimal.ZERO;

    /**
     * 涨吨
     */
    private BigDecimal more = BigDecimal.ZERO;

    /**
     * 保险费
     */
    private BigDecimal premium = BigDecimal.ZERO;

    /**
     * 信息费
     */
    private BigDecimal info = BigDecimal.ZERO;

    /**
     * 内保费
     */
    private BigDecimal inprotect = BigDecimal.ZERO;

    /**
     * 罚款
     */
    private BigDecimal punish = BigDecimal.ZERO;

    /**
     * 欠款
     */
    private BigDecimal debt = BigDecimal.ZERO;

    /**
     * 装卸费
     */
    private BigDecimal handling = BigDecimal.ZERO;

    /**
     * 奖金
     */
    private BigDecimal bonus = BigDecimal.ZERO;

    /**
     * 补贴费
     */
    private BigDecimal subsidy = BigDecimal.ZERO;

    /**
     * 抹零
     */
    private BigDecimal smallchange = BigDecimal.ZERO;

    /**
     * 个税
     */
    private BigDecimal individual = BigDecimal.ZERO;

    /**
     * 总计应付(元)
     */
    private BigDecimal totalMoney = BigDecimal.ZERO;

    /**
     * 账单状态:0-未对账;1-核实中;2-已对账;3-已支付;4-已开票;5-支付失败
     */
    private Integer payBillState;

    /**
     * 异常状态
     */
    private Integer errorState;

    /**
     * 支付时间
     */
    private Date payTime;

    /**
     * 支付方式:1-线上支付;2-线下支付
     */
    private Integer paymentModel;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 创建人
     */
    private String createUser;

    /**
     * 货主id
     */
    private Long goodsOwnerId;

    /**
     * 货主名称
     */
    private String goodsOwnerName;
}
