package com.esv.freight.app.module.message.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @description: APP业务消息表
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.message.entity.BusinessMessageEntity
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/06/09 17:00
 * @version:1.0
 */
@Data
@TableName("app_business_message")
public class BusinessMessageEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     *
     */
    @TableId
    private Long id;

    /**
     * 租户ID
     */
    private Long tenantId;

    /**
     * 部门ID
     */
    private Long departmentId;

    /**
     * 帐号ID
     */
    private Long accountId;

    /**
     * 帐号类型：1-司机、2-货主
     */
    private Integer accountType;

    /**
     * 消息本文内容
     */
    private String messageContent;

    /**
     * 消息类型 101-货主账单对账消息、102-司机账单对账消息
     */
    private Integer messageType;

    /**
     * 消息标题
     */
    private String messageTitle;

    /**
     * 消息内容(根据message_type由终端自行解析)
     */
    private String messageData;

    /**
     * 推送成功第三方返回的ID
     */
    private String msgId;

    /**
     * 是否删除 0-否；1-是
     */
    @TableLogic
    private Boolean deleted;

    /**
     * 是否已读 0-未读；1-已读
     */
    private Boolean isRead;

    /**
     * 创建时间
     */
    @TableField(fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
}
