package com.esv.freight.app.module.contract.form;

import com.esv.freight.app.common.validator.groups.ValidatorDetail;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.contract.form.ContractQueryForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/06/05 13:25
 * @version:1.0
 */
@Data
public class ContractQueryForm {

    /**
     * 合同编号
     */
    @Length(max = 64, message = "参数contractNumber长度不合法", groups = {ValidatorDetail.class})
    @NotBlank(message = "参数contractNumber不能为空", groups = {ValidatorDetail.class})
    private String contractNumber;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
