package com.esv.freight.app.module.account.form;

import com.esv.freight.app.common.validator.groups.ValidatorDelete;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import com.esv.freight.app.module.account.validator.groups.ValidatorLoginByPwd;
import com.esv.freight.app.module.account.validator.groups.ValidatorLoginBySms;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @description:
 * @project: Freight
 * @name: com.esv.freight.module.ownerBackend.account.form.LoginForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/10 16:00
 * @version:1.0
 */
@Data
public class LoginForm {

    /**
     * 手机号
     */
    @Length(min = 11, max = 11, message = "参数phone长度不合法", groups = {ValidatorInsert.class, ValidatorLoginByPwd.class, ValidatorLoginBySms.class})
    @NotBlank(message = "参数phone不能为空", groups = {ValidatorInsert.class, ValidatorLoginByPwd.class, ValidatorLoginBySms.class})
    private String phone;

    /**
     * 短信验证码
     */
    @Length(min = 6, max = 6, message = "参数smsCode长度不合法", groups = {ValidatorInsert.class, ValidatorLoginBySms.class})
    @NotBlank(message = "参数smsCode不能为空", groups = {ValidatorInsert.class, ValidatorLoginBySms.class})
    private String smsCode;

    /**
     * 密码
     */
    @Length(min = 32, max = 32, message = "参数pwd长度不合法", groups = {ValidatorInsert.class, ValidatorLoginByPwd.class})
    @NotBlank(message = "参数pwd不能为空", groups = {ValidatorInsert.class, ValidatorLoginByPwd.class})
    private String pwd;
}
