package com.esv.freight.app.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @description:
 * @project: Freight
 * @name: com.esv.freight.app.feign.TmsWaybillInterface
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/29 10:00
 * @version:1.0
 */
@FeignClient(value = "freight-tms-service")
public interface TmsWaybillInterface {

    /**
     * 运单列表
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/waybill/list")
    JSONObject listWaybills(JSONObject bodyJson);

    /**
     * 运单详情
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/waybill/detail")
    JSONObject getWaybillDetail(JSONObject bodyJson);

    /**
     * 上传发货单据
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/waybill/delivery/evidence/upload")
    JSONObject uploadDeliveryEvidence(JSONObject bodyJson);

    /**
     * 上传收货单据
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/waybill/receive/evidence/upload")
    JSONObject uploadReceiveEvidence(JSONObject bodyJson);

    /**
     * 运单签收
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "tms/waybill/sign")
    JSONObject sign(JSONObject bodyJson);
}
