package com.esv.freight.app.feign;

import com.alibaba.fastjson.JSONObject;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @description:
 * @project: Freight
 * @name: com.esv.freight.app.feign.DriverInterface
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/28 20:00
 * @version:1.0
 */
@FeignClient(value = "freight-customer-service")
public interface DriverInterface {

    /**
     * 校验司机账号密码
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/customer/carrier/driver/password/check")
    JSONObject checkAccountPwd(JSONObject bodyJson);

    /**
     * 注册司机账号
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/customer/goodsowner/account/register")
    JSONObject accountRegister(JSONObject bodyJson);

    /**
     * 获取司机账号详情
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/customer/goodsowner/account/detail")
    JSONObject getAccountDetail(JSONObject bodyJson);

    /**
     * 更改司机账号信息
     * @param bodyJson
     * @return
     */
    @PostMapping(value = "/customer/goodsowner/account/edit")
    JSONObject updateAccountInfo(JSONObject bodyJson);
}
