package com.esv.freight.app.module.account.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * APP用户登录信息表
 *
 * @author 张志臣
 * @email zhangzhichen@esvtek.com
 * @date 2020-04-13 16:00
 */
@Data
@TableName("app_login_info")
public class AppLoginEntity implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId
    private Long id;
    /**
     * 手机号码
     */
    private String phone;
    /**
     * 访问token
     */
    private String accessToken;
    /**
     * 刷新token
     */
    private String refreshToken;
    /**
     * 设备序列号
     */
    private String sn;
    /**
     * 登录状态：1-登录中、2-已登出
     */
    private String loginStatus;
    /**
     * 登录时间
     */
    private Date loginTime;
    /**
     * 登出时间
     */
    private Date logoutTime;
    /**
     * token刷新时间
     */
    private Date refreshTime;
    /**
     * 访问token有效期
     */
    private Date accessTokenValidTime;
    /**
     * 刷新token有效期
     */
    private Date refreshTokenValidTime;
}
