package com.esv.freight.app.module.waybill.form;

import com.esv.freight.app.common.validator.groups.ValidatorDetail;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import java.util.List;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.waybill.form.WaybillQueryForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/04/22 11:00
 * @version:1.0
 */
@Data
public class WaybillQueryForm {

    /**
     * 运单ID
     */
    @NotNull(message = "参数运单ID不能为空", groups = {ValidatorDetail.class})
    private Long waybillId;

    /**
     * 账号ID
     */
    @Positive(message = "参数账号ID不合法", groups = {ValidatorList.class})
    @NotNull(message = "参数账号ID不能为空", groups = {ValidatorList.class})
    private Long userId;

    /**
     * 运单号
     */
    @Length(max = 30, message = "参数运单号长度不合法", groups = {ValidatorList.class})
    private String waybillNo;

    /**
     * 订单号
     */
    @Length(max = 30, message = "参数订单号长度不合法", groups = {ValidatorList.class})
    private String orderNo;

    /**
     * 运单状态：1-装货中、2-运输中、3-已交货、4-已签收、5-已回单、6-已作废
     */
    private List<Integer> waybillStateList;

    /**
     * 当前页数
     */
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Long pageNum;

    /**
     * 每页显示记录数
     */
    @Range(min = 1, max = 1000, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Long pageSize;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
