package com.esv.freight.app.module.evaluate.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.esv.freight.app.common.response.EResponse;
import com.esv.freight.app.common.util.FeignUtils;
import com.esv.freight.app.common.validator.groups.ValidatorDetail;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import com.esv.freight.app.feign.OwnerEvaluateInterface;
import com.esv.freight.app.module.evaluate.form.OwnerEvaluateForm;
import com.esv.freight.app.module.evaluate.pojo.OwnerEvaluatePojo;
import com.esv.freight.app.module.evaluate.vo.EvaluateListItemVO;
import com.esv.freight.app.module.evaluate.vo.EvaluateListVO;
import com.esv.freight.app.module.evaluate.vo.OwnerEvaluateDetailVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @description: 货主评价Controller
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.evaluate.controller.OwnerEvaluateController
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/05/30 14:20
 * @version:1.0
 */
@RestController
@RequestMapping("/ownerBackend/evaluate")
@Slf4j
@Validated
public class OwnerEvaluateController {

    private OwnerEvaluateInterface ownerEvaluateInterface;

    @Autowired
    public OwnerEvaluateController(OwnerEvaluateInterface ownerEvaluateInterface) {
        this.ownerEvaluateInterface = ownerEvaluateInterface;
    }

    /**
     * description 获取评价列表
     * param complaintForm
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/05/30 14:30
     **/
    @PostMapping("/list")
    public EResponse list(@RequestBody(required=false) @Validated(ValidatorList.class) OwnerEvaluateForm ownerEvaluateForm) {

        // 调用评价列表分页查询接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("goodsOwnerName", ownerEvaluateForm.getGoodsOwnerName());
        reqJson.put("pageNum", ownerEvaluateForm.getPageNum());
        reqJson.put("pageSize", ownerEvaluateForm.getPageSize());
        log.info(reqJson.toJSONString());
        JSONObject result = ownerEvaluateInterface.list(reqJson);
        log.info(result.toJSONString());

        if(!FeignUtils.isFeignSuccess(result)) {
            return FeignUtils.getFeignEResponse(result);
        }

        EvaluateListVO pageResultVO = new EvaluateListVO();
        JSONObject data = result.getJSONObject("data");
        pageResultVO.setPageSize(data.getLong("pageSize"));
        pageResultVO.setPageNum(data.getLong("pageNum"));
        pageResultVO.setTotal(data.getLong("totalSize"));
        pageResultVO.setRecordSize(data.getLong("recordSize"));
        if(pageResultVO.getRecordSize() > 0) {
            JSONArray items = data.getJSONArray("records");
            List<EvaluateListItemVO> records = new ArrayList<>();
            for(int i=0; i<items.size(); ++i) {
                EvaluateListItemVO vo = new EvaluateListItemVO();
                JSONObject object = items.getJSONObject(i);
                vo.setId(object.getLong("id"));
                vo.setCustomerId(object.getLong("driverId"));
                vo.setCustomerName(object.getString("driverName"));
                vo.setWaybillId(object.getLong("waybillId"));
                vo.setWaybillNo(object.getString("waybillNo"));
                records.add(vo);
            }

            pageResultVO.setRecord(records);
        }
        return EResponse.ok(pageResultVO);
    }

    /**
     * description 获取评价详情
     * param complaintForm
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/05/30 14:30
     **/
    @RequestMapping("/detail")
    public EResponse detail(@RequestBody @Validated(ValidatorDetail.class) OwnerEvaluateForm ownerEvaluateForm) {

        // 调用评价详情接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("id", ownerEvaluateForm.getId());
        log.info(reqJson.toJSONString());
        JSONObject result = ownerEvaluateInterface.detail(reqJson);
        log.info(result.toJSONString());

        if(!FeignUtils.isFeignSuccess(result)) {
            return FeignUtils.getFeignEResponse(result);
        }

        OwnerEvaluatePojo ownerEvaluatePojo = JSONObject.toJavaObject(FeignUtils.getFeignDataJson(result), OwnerEvaluatePojo.class);
        OwnerEvaluateDetailVO ownerEvaluateDetailVO = new OwnerEvaluateDetailVO();
        BeanUtils.copyProperties(ownerEvaluatePojo, ownerEvaluateDetailVO);
        ownerEvaluateDetailVO.setCustomerId(ownerEvaluatePojo.getDriverId());
        ownerEvaluateDetailVO.setCustomerName(ownerEvaluatePojo.getDriverName());
        return EResponse.ok(ownerEvaluateDetailVO);
    }

    /**
     * description 添加评价
     * param complaintForm
     * return com.esv.freight.common.response.EResponse
     * author 张志臣
     * createTime 2020/05/30 14:30
     **/
    @RequestMapping("/add")
    public EResponse add(@RequestBody @Validated(ValidatorInsert.class) OwnerEvaluateForm ownerEvaluateForm) {

        // 调用添加评价接口
        JSONObject reqJson = new JSONObject();
        reqJson.put("goodsOwnerId", ownerEvaluateForm.getGoodsOwnerId());
        reqJson.put("goodsOwnerName", ownerEvaluateForm.getGoodsOwnerName());
        reqJson.put("waybillId", ownerEvaluateForm.getWaybillId());
        reqJson.put("onTimeLoading", ownerEvaluateForm.getOnTimeLoading());
        reqJson.put("onTimeUnloading", ownerEvaluateForm.getOnTimeUnloading());
        reqJson.put("safeArrival", ownerEvaluateForm.getSafeArrival());
        reqJson.put("serviceAttitude", ownerEvaluateForm.getServiceAttitude());
        reqJson.put("appraiseContent", ownerEvaluateForm.getAppraiseContent());
        log.info(reqJson.toJSONString());
        JSONObject result = ownerEvaluateInterface.add(reqJson);
        log.info(result.toJSONString());

        if(!FeignUtils.isFeignSuccess(result)) {
            return FeignUtils.getFeignEResponse(result);
        }

        return EResponse.ok();
    }
}
