package com.esv.freight.app.module.complaint.form;

import com.esv.freight.app.common.validator.groups.ValidatorDetail;
import com.esv.freight.app.common.validator.groups.ValidatorInsert;
import com.esv.freight.app.common.validator.groups.ValidatorList;
import com.esv.freight.app.common.validator.groups.ValidatorUpdate;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.complaint.form.ComplaintForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/05/28 14:00
 * @version:1.0
 */
@Data
public class ComplaintForm {

    /**
     * 主键
     */
    @NotNull(message = "参数id不能为空", groups = {ValidatorUpdate.class, ValidatorDetail.class})
    private Long id;

    /**
     * 账号ID
     */
    @NotNull(message = "参数账号id不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private Long userId;

    /**
     * 运单ID
     */
    @NotNull(message = "参数运单id不能为空", groups = {ValidatorInsert.class})
    private Long waybillId;

    /**
     * 投诉对象，1-司机，2-平台，3-其他
     */
    @NotNull(message = "参数投诉对象不能为空", groups = {ValidatorInsert.class})
    @Range(min = 0, max = 2, message = "无效的投诉对象", groups = {ValidatorInsert.class})
    private Integer complaintObject;

    /**
     * 投诉类型，1-运输失效；2-运输质量；3-服务态度；4-其他
     */
    @NotNull(message = "参数投诉类型不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @Range(min = 0, max = 3, message = "无效的投诉类型", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private Integer complaintType;

    /**
     * 投诉内容
     */
    @NotNull(message = "参数投诉内容不能为空", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    @Length(max = 1000, message = "参数投诉内容长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String complaintContent;

    /**
     * 照片01URL
     */
    @Length(max = 200, message = "参数pictureUrl01长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String pictureUrl01;
    /**
     * 照片02URL
     */
    @Length(max = 200, message = "参数pictureUrl02长度不合法", groups = {ValidatorInsert.class, ValidatorUpdate.class})
    private String pictureUrl02;

    /**
     * 货主姓名
     */
    @Length(max = 64, message = "参数货主姓名长度不合法", groups = {ValidatorList.class, ValidatorUpdate.class})
    @NotBlank(message = "参数货主姓名不能为空", groups = {ValidatorList.class, ValidatorUpdate.class})
    private String goodsOwnerName;

    /**
     * 当前页数
     */
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Long pageNum;

    /**
     * 每页显示记录数
     */
    @Range(min = 1, max = 1000, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Long pageSize;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
