package com.esv.freight.app.module.waybill.form;

import com.esv.freight.app.common.validator.groups.ValidatorList;
import com.esv.freight.app.module.account.validator.groups.ValidatorLoginByPwd;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
/**
 * @description:
 * @project: freight-app-service
 * @name: com.esv.freight.app.module.waybill.form.WaybillMultiQueryForm
 * @author: 张志臣
 * @email: zhangzhichen@esvtek.com
 * @createTime: 2020/05/09 14:00
 * @version:1.0
 */
@Data
public class WaybillMultiQueryForm {

    /**
     * 运单号
     */
    @Length(max = 64, message = "参数condition长度不合法", groups = {ValidatorList.class})
    @NotBlank(message = "参数condition不能为空", groups = {ValidatorList.class})
    private String condition;

    /**
     * 当前页数
     */
    @NotNull(message = "参数pageNum不能为空", groups = {ValidatorList.class})
    private Long pageNum;

    /**
     * 每页显示记录数
     */
    @Range(min = 1, max = 1000, message = "pageSize", groups = {ValidatorList.class})
    @NotNull(message = "参数pageSize不能为空", groups = {ValidatorList.class})
    private Long pageSize;

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.JSON_STYLE);
    }
}
